<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class WOOMULTI_CURRENCY_Admin_Reports
 */
class WOOMULTI_CURRENCY_Admin_Reports {
	protected $settings;
	protected $currencies;
	protected $currency;
	protected $results;
	protected $chart_interval;
	protected $where_meta;
	protected $total_sales;
	protected $order_items;
	protected $current_range;
	protected $default_currency;
	protected static $target_rate;
	protected $is_dashboard;
	protected $in_shop_order;

	function __construct() {
		$this->settings     = WOOMULTI_CURRENCY_Data::get_ins();
		$this->is_dashboard = false;
		add_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue_scripts' ) );
		add_filter( 'woocommerce_reports_get_order_report_data_args', array( $this, 'report_by_currency' ) );
		add_filter( 'woocommerce_reports_get_order_report_data', array(
			$this,
			'woocommerce_reports_get_order_report_data_for_dashboard'
		), 10, 2 );
		add_filter( 'woocommerce_currency', array( $this, 'woocommerce_currency' ), 99 );
		add_filter( 'wc_get_price_decimals', array( $this, 'wc_get_price_decimals' ), 99 );
		$this->default_currency = $this->settings->get_default_currency();
		$this->currencies       = $this->settings->get_list_currencies();

		add_action( 'woocommerce_admin_order_item_headers', array( $this, 'woocommerce_admin_order_item_headers' ) );
	}

	/**Get current range to recalculate report data
	 * @return string
	 */
	public function get_current_range() {
		if ( $this->current_range === null ) {
			$this->current_range = ! empty( $_GET['range'] ) ? sanitize_text_field( wp_unslash( $_GET['range'] ) ) : '7day';
			if ( ! in_array( $this->current_range, array(
				'custom',
				'year',
				'last_month',
				'month',
				'7day'
			), true ) ) {
				$this->current_range = '7day';
			}
		}

		return $this->current_range;
	}

	public function admin_enqueue_scripts() {
		$screen    = get_current_screen();
		$screen_id = $screen ? $screen->id : '';
		if ( 'woocommerce_page_wc-reports' === $screen_id ) {
			$tab             = isset( $_REQUEST['tab'] ) ? wp_unslash( $_REQUEST['tab'] ) : 'orders';
			$report          = isset( $_REQUEST['report'] ) ? wp_unslash( $_REQUEST['report'] ) : '';
			$currency        = isset( $_REQUEST['wmc-currency'] ) ? strtoupper( wp_unslash( $_REQUEST['wmc-currency'] ) ) : '';
			$target_currency = isset( $_REQUEST['wmc-target-currency'] ) ? strtoupper( wp_unslash( $_REQUEST['wmc-target-currency'] ) ) : '';
			if ( isset( $this->currencies[ $target_currency ] ) ) {
				self::$target_rate = $this->currencies[ $target_currency ]['rate'];
			}
			$view_default = isset( $_REQUEST['wmc-view-default-currency'] ) ? wp_unslash( $_REQUEST['wmc-view-default-currency'] ) : '';
			if ( ( $tab === 'orders' && $report !== 'coupon_usage' ) || ( $tab === 'customers' && $report === 'customers' ) ) {
				wp_enqueue_style( 'woocommerce-multi-currency-admin-reports', WOOMULTI_CURRENCY_CSS . 'reports.css', '', WOOMULTI_CURRENCY_VERSION );
				wp_enqueue_script( 'woocommerce-multi-currency-admin-reports', WOOMULTI_CURRENCY_JS . 'reports.js', array( 'jquery' ), WOOMULTI_CURRENCY_VERSION );
				wp_localize_script( 'woocommerce-multi-currency-admin-reports', 'woocommerce_multi_currency_admin_reports', array(
					'currency' => $currency ? $currency : 'all-currencies'
				) );
				add_action( 'admin_footer', array( $this, 'admin_footer' ) );
			}
			if ( ! $currency ) {
				if ( $tab === 'orders' ) {
					if ( ! $report || $report === 'sales_by_date' || apply_filters( 'wmc_admin_reports', false, $report ) ) {
						add_filter( 'woocommerce_reports_get_order_report_data_args', array(
							$this,
							'add_return_order_id'
						) );
						add_filter( 'woocommerce_reports_get_order_report_data', array(
							$this,
							'woocommerce_reports_get_order_report_data_1'
						), 10, 2 );
					} elseif ( $report === 'sales_by_product' && ! empty( $_REQUEST['product_ids'] ) ) {
						include_once( WC()->plugin_path() . '/includes/admin/reports/class-wc-admin-report.php' );
						include_once( WC()->plugin_path() . '/includes/admin/reports/class-wc-report-sales-by-product.php' );
						$current_range = $this->get_current_range();
						$results       = array();
						if ( count( $this->currencies ) ) {
							foreach ( $this->currencies as $currency_code => $currency_data ) {
								$this->currency = $currency_code;
								add_filter( 'woocommerce_reports_get_order_report_data_args', array(
									$this,
									'report_by_currency_for_all'
								) );
								$report = new WC_Report_Sales_By_Product();
								$report->check_current_range_nonce( $current_range );
								$report->calculate_current_range( $current_range );
								$total_sales = $report->get_order_report_data(
									array(
										'data'         => array(
											'_line_total' => array(
												'type'            => 'order_item_meta',
												'order_item_type' => 'line_item',
												'function'        => 'SUM',
												'name'            => 'order_item_amount',
											),
										),
										'where_meta'   => array(
											'relation' => 'OR',
											array(
												'type'       => 'order_item_meta',
												'meta_key'   => array( '_product_id', '_variation_id' ),
												// phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_meta_key
												'meta_value' => $report->product_ids,
												// phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_meta_value
												'operator'   => 'IN',
											),
										),
										'query_type'   => 'get_var',
										'filter_range' => true,
										'order_status' => array( 'completed', 'processing', 'on-hold', 'refunded' ),
									)
								);

								$results[] = self::convert_to_target_currency( $total_sales, $currency_data['rate'] );
								remove_filter( 'woocommerce_reports_get_order_report_data_args', array(
									$this,
									'report_by_currency_for_all'
								) );
							}
						}
						add_filter( 'woocommerce_reports_get_order_report_data', array(
							$this,
							'woocommerce_reports_get_order_report_data'
						), 10, 2 );
						$this->total_sales = array_sum( $results );
					} elseif ( $report === 'sales_by_category' && ! empty( $_REQUEST['show_categories'] ) ) {
						include_once( WC()->plugin_path() . '/includes/admin/reports/class-wc-admin-report.php' );
						include_once( WC()->plugin_path() . '/includes/admin/reports/class-wc-report-sales-by-category.php' );
						$current_range = $this->get_current_range();
						$results       = array();
						if ( count( $this->currencies ) ) {
							foreach ( $this->currencies as $currency_code => $currency_data ) {
								$this->currency = $currency_code;
								add_filter( 'woocommerce_reports_get_order_report_data_args', array(
									$this,
									'report_by_currency_for_all'
								) );
								$report = new WC_Report_Sales_By_Category();
								$report->check_current_range_nonce( $current_range );
								$report->calculate_current_range( $current_range );
								$order_items = $report->get_order_report_data(
									array(
										'data'         => array(
											'_product_id' => array(
												'type'            => 'order_item_meta',
												'order_item_type' => 'line_item',
												'function'        => '',
												'name'            => 'product_id',
											),
											'_line_total' => array(
												'type'            => 'order_item_meta',
												'order_item_type' => 'line_item',
												'function'        => 'SUM',
												'name'            => 'order_item_amount',
											),
											'post_date'   => array(
												'type'     => 'post_data',
												'function' => '',
												'name'     => 'post_date',
											),
										),
										'group_by'     => 'ID, product_id, post_date',
										'query_type'   => 'get_results',
										'filter_range' => true,
									)
								);
								if ( is_array( $order_items ) && count( $order_items ) ) {
									foreach ( $order_items as $order_item ) {
										$order_item->order_item_amount = self::convert_to_target_currency( $order_item->order_item_amount, $currency_data['rate'] );
									}
								}
								$results = array_merge( $results, $order_items );
								remove_filter( 'woocommerce_reports_get_order_report_data_args', array(
									$this,
									'report_by_currency_for_all'
								) );
							}
						}
						add_filter( 'woocommerce_reports_get_order_report_data', array(
							$this,
							'woocommerce_reports_get_order_report_data'
						), 10, 2 );
						$this->order_items = $results;
					}
				}
			} elseif ( $view_default === 'yes' && $this->default_currency !== $currency ) {
				if ( ! $report || $report === 'sales_by_date' || apply_filters( 'wmc_admin_reports', false, $report ) ) {
					$this->currency = $currency;
					if ( isset( $this->currencies[ $this->currency ] ) ) {
						include_once( WC()->plugin_path() . '/includes/admin/reports/class-wc-admin-report.php' );
						include_once( WC()->plugin_path() . '/includes/admin/reports/class-wc-report-sales-by-date.php' );
						$current_range = $this->get_current_range();
						$results       = array();
						add_filter( 'woocommerce_reports_get_order_report_data_args', array(
							$this,
							'report_by_currency_for_all'
						) );
						$report = new WC_Report_Sales_By_Date();
						$report->check_current_range_nonce( $current_range );
						$report->calculate_current_range( $current_range );
						$result               = $report->get_report_data();
						$this->chart_interval = $report->chart_interval;
						if ( isset( $result->orders ) && is_array( $result->orders ) && count( $result->orders ) ) {
							foreach ( $result->orders as $order ) {
								$order->total_sales        = self::convert_to_target_currency( $order->total_sales, $this->currencies[ $this->currency ]['rate'] );
								$order->total_shipping     = self::convert_to_target_currency( $order->total_shipping, $this->currencies[ $this->currency ]['rate'] );
								$order->total_tax          = self::convert_to_target_currency( $order->total_tax, $this->currencies[ $this->currency ]['rate'] );
								$order->total_shipping_tax = self::convert_to_target_currency( $order->total_shipping_tax, $this->currencies[ $this->currency ]['rate'] );
							}
						}
						if ( isset( $result->refunded_orders ) && is_array( $result->refunded_orders ) && count( $result->refunded_orders ) ) {
							foreach ( $result->refunded_orders as $refunded_orders ) {
								$refunded_orders->total_refund       = self::convert_to_target_currency( $refunded_orders->total_refund, $this->currencies[ $this->currency ]['rate'] );
								$refunded_orders->total_shipping     = self::convert_to_target_currency( $refunded_orders->total_shipping, $this->currencies[ $this->currency ]['rate'] );
								$refunded_orders->total_tax          = self::convert_to_target_currency( $refunded_orders->total_tax, $this->currencies[ $this->currency ]['rate'] );
								$refunded_orders->total_shipping_tax = self::convert_to_target_currency( $refunded_orders->total_shipping_tax, $this->currencies[ $this->currency ]['rate'] );
								$refunded_orders->net_refund         = self::convert_to_target_currency( $refunded_orders->net_refund, $this->currencies[ $this->currency ]['rate'] );
							}
						}
						if ( isset( $result->refund_lines ) && is_array( $result->refund_lines ) && count( $result->refund_lines ) ) {
							foreach ( $result->refund_lines as $refund_lines ) {
								$refund_lines->total_refund       = self::convert_to_target_currency( $refund_lines->total_refund, $this->currencies[ $this->currency ]['rate'] );
								$refund_lines->total_shipping     = self::convert_to_target_currency( $refund_lines->total_shipping, $this->currencies[ $this->currency ]['rate'] );
								$refund_lines->total_tax          = self::convert_to_target_currency( $refund_lines->total_tax, $this->currencies[ $this->currency ]['rate'] );
								$refund_lines->total_shipping_tax = self::convert_to_target_currency( $refund_lines->total_shipping_tax, $this->currencies[ $this->currency ]['rate'] );
								$refund_lines->total_sales        = self::convert_to_target_currency( $refund_lines->total_sales, $this->currencies[ $this->currency ]['rate'] );
							}
						}
						$result->total_tax                   = self::convert_to_target_currency( $result->total_tax, $this->currencies[ $this->currency ]['rate'] );
						$result->total_shipping              = self::convert_to_target_currency( $result->total_shipping, $this->currencies[ $this->currency ]['rate'] );
						$result->total_shipping_tax          = self::convert_to_target_currency( $result->total_shipping_tax, $this->currencies[ $this->currency ]['rate'] );
						$result->total_sales                 = self::convert_to_target_currency( $result->total_sales, $this->currencies[ $this->currency ]['rate'] );
						$result->net_sales                   = self::convert_to_target_currency( $result->net_sales, $this->currencies[ $this->currency ]['rate'] );
						$result->total_tax_refunded          = self::convert_to_target_currency( $result->total_tax_refunded, $this->currencies[ $this->currency ]['rate'] );
						$result->total_shipping_refunded     = self::convert_to_target_currency( $result->total_shipping_refunded, $this->currencies[ $this->currency ]['rate'] );
						$result->total_shipping_tax_refunded = self::convert_to_target_currency( $result->total_shipping_tax_refunded, $this->currencies[ $this->currency ]['rate'] );
						$result->total_refunds               = self::convert_to_target_currency( $result->total_refunds, $this->currencies[ $this->currency ]['rate'] );
						$results[]                           = $result;
						remove_filter( 'woocommerce_reports_get_order_report_data_args', array(
							$this,
							'report_by_currency_for_all'
						) );
						add_filter( 'woocommerce_admin_report_data', array( $this, 'woocommerce_admin_report_data' ) );
						$this->results = $results;
					}
				} elseif ( $report === 'sales_by_product' && ! empty( $_REQUEST['product_ids'] ) ) {
					$this->currency = $currency;
					if ( isset( $this->currencies[ $this->currency ] ) ) {
						include_once( WC()->plugin_path() . '/includes/admin/reports/class-wc-admin-report.php' );
						include_once( WC()->plugin_path() . '/includes/admin/reports/class-wc-report-sales-by-product.php' );
						$current_range = $this->get_current_range();
						add_filter( 'woocommerce_reports_get_order_report_data_args', array(
							$this,
							'report_by_currency_for_all'
						) );
						$report = new WC_Report_Sales_By_Product();
						$report->check_current_range_nonce( $current_range );
						$report->calculate_current_range( $current_range );
						$total_sales = $report->get_order_report_data(
							array(
								'data'         => array(
									'_line_total' => array(
										'type'            => 'order_item_meta',
										'order_item_type' => 'line_item',
										'function'        => 'SUM',
										'name'            => 'order_item_amount',
									),
								),
								'where_meta'   => array(
									'relation' => 'OR',
									array(
										'type'       => 'order_item_meta',
										'meta_key'   => array( '_product_id', '_variation_id' ),
										// phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_meta_key
										'meta_value' => $report->product_ids,
										// phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_meta_value
										'operator'   => 'IN',
									),
								),
								'query_type'   => 'get_var',
								'filter_range' => true,
								'order_status' => array( 'completed', 'processing', 'on-hold', 'refunded' ),
							)
						);
						remove_filter( 'woocommerce_reports_get_order_report_data_args', array(
							$this,
							'report_by_currency_for_all'
						) );
						add_filter( 'woocommerce_reports_get_order_report_data', array(
							$this,
							'woocommerce_reports_get_order_report_data'
						), 10, 2 );
						$this->total_sales = self::convert_to_target_currency( $total_sales, $this->currencies[ $this->currency ]['rate'] );
					}
				} elseif ( $report === 'sales_by_category' && ! empty( $_REQUEST['show_categories'] ) ) {
					$this->currency = $currency;
					if ( isset( $this->currencies[ $this->currency ] ) ) {
						include_once( WC()->plugin_path() . '/includes/admin/reports/class-wc-admin-report.php' );
						include_once( WC()->plugin_path() . '/includes/admin/reports/class-wc-report-sales-by-category.php' );
						$current_range = $this->get_current_range();
						add_filter( 'woocommerce_reports_get_order_report_data_args', array(
							$this,
							'report_by_currency_for_all'
						) );
						$report = new WC_Report_Sales_By_Category();
						$report->check_current_range_nonce( $current_range );
						$report->calculate_current_range( $current_range );
						$order_items = $report->get_order_report_data(
							array(
								'data'         => array(
									'_product_id' => array(
										'type'            => 'order_item_meta',
										'order_item_type' => 'line_item',
										'function'        => '',
										'name'            => 'product_id',
									),
									'_line_total' => array(
										'type'            => 'order_item_meta',
										'order_item_type' => 'line_item',
										'function'        => 'SUM',
										'name'            => 'order_item_amount',
									),
									'post_date'   => array(
										'type'     => 'post_data',
										'function' => '',
										'name'     => 'post_date',
									),
								),
								'group_by'     => 'ID, product_id, post_date',
								'query_type'   => 'get_results',
								'filter_range' => true,
							)
						);

						if ( is_array( $order_items ) && count( $order_items ) ) {
							foreach ( $order_items as $order_item ) {
								$order_item->order_item_amount = self::convert_to_target_currency( $order_item->order_item_amount, $this->currencies[ $this->currency ]['rate'] );
							}

							$this->order_items = $order_items;
							add_filter( 'woocommerce_reports_get_order_report_data', array(
								$this,
								'woocommerce_reports_get_order_report_data'
							), 10, 2 );
						}
						remove_filter( 'woocommerce_reports_get_order_report_data_args', array(
							$this,
							'report_by_currency_for_all'
						) );
					}
				}
			}
		}
	}

	/**
	 * @param $price
	 * @param $rate
	 *
	 * @return float|int
	 */
	public static function convert_to_target_currency( $price, $rate ) {
		$price = $price / $rate;
		if ( self::$target_rate !== null ) {
			$price = $price * self::$target_rate;
		}

		return $price;
	}

	/**
	 *
	 */
	public function admin_footer() {
		$currency          = isset( $_REQUEST['wmc-currency'] ) ? strtoupper( wp_unslash( $_REQUEST['wmc-currency'] ) ) : '';
		$target_currency   = isset( $_REQUEST['wmc-target-currency'] ) ? strtoupper( wp_unslash( $_REQUEST['wmc-target-currency'] ) ) : '';
		$view_default      = isset( $_REQUEST['wmc-view-default-currency'] ) ? wp_unslash( $_REQUEST['wmc-view-default-currency'] ) : '';
		$view_default_link = $view_default === 'yes' ? remove_query_arg( 'wmc-view-default-currency', $_SERVER['REQUEST_URI'] ) : add_query_arg( array( 'wmc-view-default-currency' => 'yes' ), $_SERVER['REQUEST_URI'] );
		$links             = $this->settings->get_links();
		$currency_name     = get_woocommerce_currencies();
		?>
        <li class="wmc-reports-currency-selector">
            <div class="woocommerce-multi-currency shortcode">
                <div class="wmc-currency">
                    <select class="wmc-nav"
                            onchange="this.options[this.selectedIndex].value && (window.location = this.options[this.selectedIndex].value);">
						<?php
						foreach ( $links as $code => $link ) {
							?>
                            <option <?php selected( $target_currency, $code ) ?>
                                    value="<?php echo remove_query_arg( array(
										'wmc-currency',
										'wmc-view-default-currency'
									), add_query_arg( array( 'wmc-target-currency' => $code ), $_SERVER['REQUEST_URI'] ) ) ?>"><?php echo esc_html( "All currencies(to {$code})" ) ?></option>
							<?php
						}
						foreach ( $links as $code => $link ) {
							?>
                            <option <?php selected( $currency, $code ) ?>
                                    value="<?php echo esc_url( remove_query_arg( array( 'wmc-target-currency' ), $link ) ) ?>"><?php echo esc_html( $currency_name[ $code ] ) ?></option>
							<?php
						}
						?>
                    </select>
                </div>
            </div>
        </li>
		<?php
		if ( $currency && $currency !== $this->default_currency ) {
			?>
            <li class="wmc-view-default-currency-container">
                <input id="wmc-view-default-currency" type="checkbox"
                       value="yes" <?php checked( $view_default, 'yes' ) ?>
                       data-report_link="<?php esc_attr_e( remove_query_arg( array( 'wmc-target-currency' ), $view_default_link ) ) ?>"><label
                        for="wmc-view-default-currency"><?php printf( esc_html__( 'View in default currency(%s)', 'woocommerce-multi-currency' ), $this->default_currency ) ?></label>
            </li>
			<?php
		}
	}

	/**Filter orders by each currency
	 *
	 * @param $args
	 *
	 * @return mixed
	 */
	public function report_by_currency_for_all( $args ) {
		$args['where_meta'][]           = array(
			'meta_key'   => '_order_currency',
			'meta_value' => $this->currency,
			'operator'   => '=',
		);
		$args['where_meta']['relation'] = 'AND';

		$args['nocache'] = true;

		return $args;
	}

	public function add_return_order_id( $args ) {
		if ( ! isset( $args['data']['ID'] ) ) {
			if ( ! empty( $args['data']['_order_total'] ) ) {
				$args['data']['ID']                       = array(
					'type'     => 'post_data',
					'function' => '',
					'name'     => 'order_id',
				);
				$args['group_by']                         = 'order_id';
				$args['data']['_order_total']['function'] = '';
			} elseif ( ! empty( $args['data']['_line_total'] ) ) {
				$args['data']['ID']                      = array(
					'type'     => 'post_data',
					'function' => '',
					'name'     => 'order_id',
				);
				$args['group_by']                        = 'order_id';
				$args['data']['_line_total']['function'] = '';
			}

		}
		$args['nocache'] = true;

		return $args;
	}

	/**Convert to default currency for WooCommerce Status in WP dashboard
	 *
	 * @param $result
	 * @param $data
	 *
	 * @return mixed
	 */
	public function woocommerce_reports_get_order_report_data_for_dashboard( $result, $data ) {
		if ( $this->is_dashboard ) {
			if ( count( array_keys( $data ) ) === 3 && count( array_intersect( array_keys( $data ), array(
					'_order_total',
					'post_date',
					'ID'
				) ) ) === 3 ) {
				if ( is_array( $result ) && count( $result ) ) {
					foreach ( $result as $key => $value ) {
						$order_id        = $value->order_id;
						$_order_currency = get_post_meta( $order_id, '_order_currency', true );
						$wmc_order_info  = get_post_meta( $order_id, 'wmc_order_info', true );
						$rate            = 0;
						if ( isset( $wmc_order_info[ $this->default_currency ] ) && isset( $wmc_order_info[ $this->default_currency ]['is_main'] ) && $wmc_order_info[ $this->default_currency ]['is_main'] == 1 ) {
							if ( isset( $wmc_order_info[ $_order_currency ] ) ) {
								$rate = $wmc_order_info[ $_order_currency ]['rate'];
							}
							if ( isset( $this->currencies[ $_order_currency ] ) ) {
								$rate = $this->currencies[ $_order_currency ]['rate'];
							}

						} elseif ( isset( $this->currencies[ $_order_currency ] ) ) {
							$rate = $this->currencies[ $_order_currency ]['rate'];
						}
						if ( $rate > 0 ) {
							$value->sparkline_value = self::convert_to_target_currency( $value->sparkline_value, $rate );
						}
					}
				}
			} else {
				$result = $this->woocommerce_reports_get_order_report_data_1( $result, $data );
			}
			$this->is_dashboard = false;
		}

		return $result;
	}

	/**
	 * @param $result
	 * @param $data
	 *
	 * @return mixed
	 */
	public function woocommerce_reports_get_order_report_data_1( $result, $data ) {
		if ( isset( $data['ID'] ) && ( ! empty( $data['_order_total'] ) || ! empty( $data['_line_total'] ) ) ) {
			foreach ( $result as $data_k => $data_obj ) {
				$order_id = isset( $data_obj->order_id ) ? $data_obj->order_id : ( isset( $data_obj->refund_id ) ? $data_obj->refund_id : '' );
				if ( $order_id ) {
					$_order_currency = get_post_meta( $order_id, '_order_currency', true );
					if ( $this->default_currency !== $_order_currency ) {
						$wmc_order_info = get_post_meta( $order_id, 'wmc_order_info', true );
						$rate           = 0;
						if ( isset( $wmc_order_info[ $this->default_currency ] ) && isset( $wmc_order_info[ $this->default_currency ]['is_main'] ) && $wmc_order_info[ $this->default_currency ]['is_main'] == 1 ) {
							if ( isset( $wmc_order_info[ $_order_currency ] ) ) {
								$rate = $wmc_order_info[ $_order_currency ]['rate'];
							}
							if ( isset( $this->currencies[ $_order_currency ] ) ) {
								$rate = $this->currencies[ $_order_currency ]['rate'];
							}

						} elseif ( isset( $this->currencies[ $_order_currency ] ) ) {
							$rate = $this->currencies[ $_order_currency ]['rate'];
						}
						if ( $rate > 0 ) {
							foreach ( $data_obj as $data_obj_k => $data_obj_v ) {
								if ( ! in_array( $data_obj_k, array( 'post_date', 'order_id', 'refund_id' ) ) ) {
									$data_obj->{$data_obj_k} = self::convert_to_target_currency( $data_obj_v, $rate );
								}
							}
						}
					} elseif ( self::$target_rate !== null ) {
						if ( isset( $data_obj->total_sales ) ) {
							$data_obj->total_sales *= self::$target_rate;
						}
						if ( isset( $data_obj->total_shipping ) ) {
							$data_obj->total_shipping *= self::$target_rate;
						}
						if ( isset( $data_obj->total_tax ) ) {
							$data_obj->total_tax *= self::$target_rate;
						}
						if ( isset( $data_obj->total_shipping_tax ) ) {
							$data_obj->total_shipping_tax *= self::$target_rate;
						}
					}
				}
			}
		}

		return $result;
	}

	/**
	 * @param $result
	 * @param $data
	 *
	 * @return mixed
	 */
	public function woocommerce_reports_get_order_report_data( $result, $data ) {
		if ( isset( $data['_line_total'] ) ) {
			if ( $this->total_sales !== null && ! is_array( $result ) ) {
				$result = $this->total_sales;
			} elseif ( $this->order_items !== null && is_array( $result ) ) {
				$result = $this->order_items;
			}
		}

		return $result;
	}

	/**Recalculate report data after converting all to default currency
	 *
	 * @param $report_data
	 *
	 * @return mixed
	 */
	public function woocommerce_admin_report_data( $report_data ) {
		if ( is_array( $this->results ) && count( $this->results ) ) {
			$report_data->orders          = array();
			$report_data->refund_lines    = array();
			$report_data->refunded_orders = array();
			$report_data->full_refunds    = array();
			foreach ( $this->results as $result ) {
				if ( isset( $result->orders ) && is_array( $result->orders ) && count( $result->orders ) ) {
					$report_data->orders = array_merge( $report_data->orders, $result->orders );
				}
				if ( isset( $result->refund_lines ) && is_array( $result->refund_lines ) && count( $result->refund_lines ) ) {
					$report_data->refund_lines = array_merge( $report_data->refund_lines, $result->refund_lines );
				}
				if ( isset( $result->refunded_orders ) && is_array( $result->refunded_orders ) && count( $result->refunded_orders ) ) {
					$report_data->refunded_orders = array_merge( $report_data->refunded_orders, $result->refunded_orders );
				}
				if ( isset( $result->full_refunds ) && is_array( $result->full_refunds ) && count( $result->full_refunds ) ) {
					$report_data->full_refunds = array_merge( $report_data->full_refunds, $result->full_refunds );
				}
			}
			$report_data->total_tax_refunded          = 0;
			$report_data->total_shipping_refunded     = 0;
			$report_data->total_shipping_tax_refunded = 0;
			$report_data->total_refunds               = 0;

			$report_data->refunded_orders = array_merge( $report_data->partial_refunds, $report_data->full_refunds );

			foreach ( $report_data->refunded_orders as $key => $value ) {
				$report_data->total_tax_refunded          += floatval( $value->total_tax < 0 ? $value->total_tax * - 1 : $value->total_tax );
				$report_data->total_refunds               += floatval( $value->total_refund );
				$report_data->total_shipping_tax_refunded += floatval( $value->total_shipping_tax < 0 ? $value->total_shipping_tax * - 1 : $value->total_shipping_tax );
				$report_data->total_shipping_refunded     += floatval( $value->total_shipping < 0 ? $value->total_shipping * - 1 : $value->total_shipping );

				// Only applies to parial.
				if ( isset( $value->order_item_count ) ) {
					$report_data->refunded_order_items += floatval( $value->order_item_count < 0 ? $value->order_item_count * - 1 : $value->order_item_count );
				}
			}
			// Totals from all orders - including those refunded. Subtract refunded amounts.
			$report_data->total_tax          = wc_format_decimal( array_sum( wp_list_pluck( $report_data->orders, 'total_tax' ) ) - $report_data->total_tax_refunded, 2 );
			$report_data->total_shipping     = wc_format_decimal( array_sum( wp_list_pluck( $report_data->orders, 'total_shipping' ) ) - $report_data->total_shipping_refunded, 2 );
			$report_data->total_shipping_tax = wc_format_decimal( array_sum( wp_list_pluck( $report_data->orders, 'total_shipping_tax' ) ) - $report_data->total_shipping_tax_refunded, 2 );

			// Total the refunds and sales amounts. Sales subract refunds. Note - total_sales also includes shipping costs.
			$report_data->total_sales = wc_format_decimal( array_sum( wp_list_pluck( $report_data->orders, 'total_sales' ) ) - $report_data->total_refunds, 2 );
			$report_data->net_sales   = wc_format_decimal( $report_data->total_sales - $report_data->total_shipping - max( 0, $report_data->total_tax ) - max( 0, $report_data->total_shipping_tax ), 2 );

			// Calculate average based on net.
			$report_data->average_sales       = wc_format_decimal( $report_data->net_sales / ( $this->chart_interval + 1 ), 2 );
			$report_data->average_total_sales = wc_format_decimal( $report_data->total_sales / ( $this->chart_interval + 1 ), 2 );

			// Total orders and discounts also includes those which have been refunded at some point.
			$report_data->total_coupons         = number_format( array_sum( wp_list_pluck( $report_data->coupons, 'discount_amount' ) ), 2, '.', '' );
			$report_data->total_refunded_orders = absint( count( $report_data->full_refunds ) );

			// Total orders in this period, even if refunded.
			$report_data->total_orders = absint( array_sum( wp_list_pluck( $report_data->order_counts, 'count' ) ) );

			// Item items ordered in this period, even if refunded.
			$report_data->total_items = absint( array_sum( wp_list_pluck( $report_data->order_items, 'order_item_count' ) ) );
			$this->results            = array();
		}

		return $report_data;
	}

	/**Set price decimal for each currency for report
	 *
	 * @param $decimal
	 *
	 * @return int
	 */
	public function wc_get_price_decimals( $decimal ) {
		$view_default = isset( $_REQUEST['wmc-view-default-currency'] ) ? wp_unslash( $_REQUEST['wmc-view-default-currency'] ) : '';

		if ( is_admin() && ! empty( $_REQUEST['wmc-currency'] ) && $view_default !== 'yes' ) {
			$currency = strtoupper( wp_unslash( $_REQUEST['wmc-currency'] ) );
			if ( $currency !== $this->default_currency ) {
				$decimal = isset( $this->currencies[ $currency ]['decimals'] ) ? $this->currencies[ $currency ]['decimals'] : 0;
			}

		}

		if ( is_admin() ) {
			if ( $this->in_shop_order ) {
				$currency = $this->in_shop_order->get_currency();
				$decimal  = isset( $this->currencies[ $currency ]['decimals'] ) ? $this->currencies[ $currency ]['decimals'] : 0;
			}
		}

		return (int) $decimal;
	}

	/**Set currency for report
	 *
	 * @param $woocommerce_currency
	 *
	 * @return string
	 */
	public function woocommerce_currency( $woocommerce_currency ) {
		global $pagenow;
		$page = isset( $_REQUEST['page'] ) ? sanitize_text_field( $_REQUEST['page'] ) : '';
		if ( $pagenow === 'admin.php' && $page === 'wc-reports' ) {
			$view_default = isset( $_REQUEST['wmc-view-default-currency'] ) ? wp_unslash( $_REQUEST['wmc-view-default-currency'] ) : '';
			$currency     = isset( $_REQUEST['wmc-currency'] ) ? strtoupper( wp_unslash( $_REQUEST['wmc-currency'] ) ) : '';
			if ( $currency && $view_default !== 'yes' ) {
				if ( $currency !== $this->default_currency ) {
					$woocommerce_currency = $currency;
				}
			} elseif ( isset( $_REQUEST['wmc-target-currency'] ) ) {
				$target_currency = strtoupper( wp_unslash( $_REQUEST['wmc-target-currency'] ) );
				if ( $target_currency !== $this->default_currency ) {
					$woocommerce_currency = $target_currency;
				}
			}
		}

		return $woocommerce_currency;
	}

	/**Filter orders by selected currency
	 *
	 * @param $args
	 *
	 * @return mixed
	 */
	public function report_by_currency( $args ) {
		global $pagenow;
		if ( $pagenow === 'index.php' ) {
			/**
			 * For WooCommerce Status in WP dashboard
			 */
			if ( ( ! empty( $args['data']['_order_total'] ) || ( ! empty( $args['data']['_product_id'] ) && ! empty( $args['data']['_line_total'] ) ) ) && empty( $args['data']['ID'] ) ) {
				$args['data']['ID'] = array(
					'type'     => 'post_data',
					'function' => '',
					'name'     => 'order_id',
				);
				$args['group_by']   = 'order_id';
				$args['nocache']    = true;
				$this->is_dashboard = true;
			}
		} else {
			$report   = isset( $_REQUEST['report'] ) ? wp_unslash( $_REQUEST['report'] ) : '';
			$tab      = isset( $_REQUEST['tab'] ) ? wp_unslash( $_REQUEST['tab'] ) : 'orders';
			$currency = isset( $_REQUEST['wmc-currency'] ) ? strtoupper( wp_unslash( $_REQUEST['wmc-currency'] ) ) : '';
			if ( $currency ) {
				if ( $currency !== $this->default_currency ) {
					$args['nocache'] = true;
				}
				if ( ( $tab === 'orders' && $report !== 'coupon_usage' ) || ( $tab === 'customers' && $report === 'customers' ) ) {
					$args['where_meta'][]           = array(
						'meta_key'   => '_order_currency',
						'meta_value' => $currency,
						'operator'   => '=',
					);
					$args['where_meta']['relation'] = 'AND';
				}
			}
		}

		return $args;
	}

	public function woocommerce_admin_order_item_headers( $order ) {
		$this->in_shop_order = $order;
	}
}